<?php
defined('FIR') OR exit();
/**
 * The template for displaying the header section
 */
?>
<!-- ==============================================
     Main Header Section
     =============================================== -->
    <header class="navbar pcoded-header navbar-expand-lg navbar-light">
        <div class="m-header">
            <a class="mobile-menu" id="mobile-collapse1" href="javascript:"><span></span></a>
            <a href="<?=$this->siteUrl()?>" class="b-brand">
                   <div class="b-bg">
                        <img class="img-fluid" style="width:40px; height: 40px;" src="<?=$this->siteUrl().'/'.PUBLIC_PATH.'/'.UPLOADS_PATH?>/admin/<?=e($this->siteSettings('logo'))?>" alt="Admin">
                   </div>
                   <span class="b-title"><?=$this->siteSettings('sitename')?></span>
               </a>
        </div>
        <a class="mobile-menu" id="mobile-header" href="javascript:">
            <i class="feather icon-more-horizontal"></i>
        </a>
        <div class="collapse navbar-collapse">
            <ul class="navbar-nav ml-auto">
                
              <li class="dropdown user user-menu">
                <!-- Menu Toggle Button -->
                <a href="#" class="dropdown-toggle" data-toggle="dropdown">
                
                  <!-- hidden-xs hides the username on small devices so only the image appears. -->
                  <span class="hidden-xs">
                  	<?=mb_strtoupper(mb_substr($data['language'], 0, 2))?>
                  </span>
                </a>
                <ul class="dropdown-menu dropdown-menu-right">
						<?php foreach($data['languages_list'] as $language): ?>
							<li class="py-2"><a href="<?=$this->siteUrl()?>/admin/lang/<?=$language?>"><?=$language?></a></li>	
						<?php endforeach ?>
        		</ul>
              </li>
                <li>
                    <div class="dropdown drp-user">
                        <a href="javascript:" class="dropdown-toggle" data-toggle="dropdown">
                            <i class="icon feather icon-settings"></i>
                        </a>
                        <div class="dropdown-menu dropdown-menu-right profile-notification">
                            <div class="pro-head">
                                <img src="<?=$this->siteUrl().'/'.PUBLIC_PATH.'/'.UPLOADS_PATH?>/admin/<?=e($data['admin']['imagelocation'])?>" class="img-radius" alt="{{ admin.name }}">
                                <span><?=e($data['admin']['name'])?></span>
                                <a href="<?=$this->siteUrl()?>/admin/logout" class="dud-logout" title="Logout">
                                    <i class="feather icon-log-out"></i>
                                </a>
                            </div>
                            <ul class="pro-body">
                                <li><a href="<?=$this->siteUrl()?>/admin/settings/site" class="dropdown-item"><i class="feather icon-settings"></i> <?=$this->lang('settings')?></a></li>
                                <li><a href="<?=$this->siteUrl()?>/admin/profile/details" class="dropdown-item"><i class="feather icon-user"></i> <?=$this->lang('profile')?></a></li>
                                <li><a href="<?=$this->siteUrl()?>/admin/logout" class="dropdown-item"><i class="feather icon-user"></i> <?=$this->lang('logout')?></a></li>
                            </ul>
                        </div>
                    </div>
                </li>
            </ul>
        </div>
    </header>
    <!-- [ Header ] end -->